/*
 * ExportAuto.jsx
 * Javascript for InDesign CS5, CS4, CS3
 * Version date: 20120425
 *
 * PURPOSE:
 * ========
 * Call the main export script 'ExportCurrentDocument.jsx' with changing parameters.
 * This enables to load different settings for various objects to export without having to make any further settings over and over again.
 *
 * Instructions:
 * -------------
 * Make a copy of this Script into the folder where 'ExportCurrentDocument.jsx' is located (one up).
 * then
 * Call 'ExportCurrentDocument.jsx'.
 * and make your settings. Cancel the dialog. This creates the file 'settings.set' in the sub folder 'zz_Settings'.
 * Rename settings.set to identify the purpose of these settings like 'settings_Product1.set'.
 * With a plain text editor edit the variable below the ****** Configurable SETTINGS ******:
 * var settingsFileName = "settings.set";
 * to
 * var settingsFileName = "settings_Product1.set";
 * Save this script.
 * 
 * Call the script from the InDesign Script palette and the export will start with the desired settings.
 *
 *
 * DISCLAIMER:
 * ===============
 * Absolutely no warranty. Use it as is or modify it to match your needs
 *
 * Author: Andreas Imhof, www.aiedv.ch
 */

// ****** Configurable SETTINGS ******

var settingsFileName = "settings.set";  // name of the settings file to load. default = "settings.set"
var settingsFilePath = "";				// Empty = default path or set to any valid path to the settings file
var silentMode = "9";                   // Flags to combine for desired Messages
                                        // -1 = absolutely no message and dialog - just do it!
                                        // 0 = show all dialogs and messages: main export dialog and processing and completion messages
                                        // 1 = no main dialog
                                        // 2 = no error message (silently quit)
                                        // 4 = no processing messages
                                        // 8 = no completion message
                                        // Example: 9 = no main dialog and no completion message


// initialize and start export
var orig_userInteractionLevel = app.scriptPreferences.userInteractionLevel;
app.scriptPreferences.userInteractionLevel = UserInteractionLevels.interactWithAll;

// call our main export script with parameters
app.scriptArgs.setValue("settingsFileName", settingsFileName);
app.scriptArgs.setValue("silentMode", "" + silentMode);

app.scriptArgs.setValue("callerScript", "" + app.activeScript.name);

var scriptpath = getScriptsPath();
if (scriptpath.toLowerCase().indexOf("zz_utilities") < 0) {
	var scriptFile = new File(scriptpath + "/ExportCurrentDocument.jsx");
	app.doScript(scriptFile,ScriptLanguage.javascript);
}
else {	// script at wrong folder
	alert("Please, read the usage Instructions within this script!\nMove this script one folder up and call it again!\n\nVerschieben Sie dieses Script um einen Ordner nach oben und rufen Sie es erneut auf!\n\n");
}
app.scriptPreferences.userInteractionLevel = orig_userInteractionLevel;

// get return values
//var numSplittedStoryBoxes = parseInt(app.scriptArgs.getValue("totalSplittedTextFrames"));

app.scriptArgs.clear();


/***************** FUNCTIONS ****************/
function getScriptsPath() {
	var fullpath = app.activeScript;
	var scriptFile = new File(fullpath);
	return(scriptFile.path);
}
